using System;
using System.Collections.Generic;
using System.Linq;
using System.Data;
using VIRP.CRS.BLL;
using VIRP.CRS.BO;

namespace VIRP.CRS.DAL
{
	public partial class STD_MENU_ITEMSDB : DBUtils
	{
        #region Fields
        #endregion

        #region Constructors

        public STD_MENU_ITEMSDB()
        {
        }

        #endregion

        #region Properties
        #endregion

        #region Methods

        public STD_MENU_ITEMS GetItem(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 MENU_ID)
        {
            STD_MENU_ITEMS objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_MENU_ITEMS_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, MENU_ID).FirstOrDefault();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_MENU_ITEMS> GetItems(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_MENU_ITEMS> objReturn = null;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objReturn = dbContext.usp_STD_MENU_ITEMS_getitems(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public Int32 Save(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, STD_MENU_ITEMS objSave)
        {
            Int32? objReturn = objSave.MENU_ID;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_STD_MENU_ITEMS_save(CURRENT_USER, CURRENT_REGISTRY_ID, DateTime.Now, objSave.CREATEDBY, objSave.INACTIVE_DATE, objSave.INACTIVE_FLAG, ref objReturn, objSave.MENU_PAGE_ID, objSave.PAGE_ID, objSave.SORT_ORDER, objSave.STD_REGISTRY_ID, objSave.STD_ROLE_ID, DateTime.Now, objSave.UPDATEDBY);
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn.GetValueOrDefault();
        }

        public Boolean Delete(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, Int32 MENU_ID)
        {
            Boolean objReturn = false;

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    dbContext.usp_STD_MENU_ITEMS_delete(CURRENT_USER, CURRENT_REGISTRY_ID, MENU_ID);
                    objReturn = true;
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_MENU_ITEMS> GetItemsByRegistry(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID)
        {
            List<STD_MENU_ITEMS> objReturn = null;
            List<STD_MENU_ITEMS_Custom> objTemp = null;

            //TODO: Cleanup and make more efficient

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objTemp = dbContext.usp_STD_MENU_ITEMS_getitemsByRegistry(CURRENT_USER, CURRENT_REGISTRY_ID).ToList();
                    if (objTemp != null)
                    {
                        objReturn = new List<STD_MENU_ITEMS>();

                        foreach (STD_MENU_ITEMS_Custom mi in objTemp)
                        {
                            STD_MENU_ITEMS menuItem = new STD_MENU_ITEMS
                            {
                                CREATED = mi.CREATED,
                                CREATEDBY = mi.CREATEDBY,
                                INACTIVE_DATE = mi.INACTIVE_DATE,
                                INACTIVE_FLAG = mi.INACTIVE_FLAG,
                                MENU_ID = mi.MENU_ID,
                                MENU_PAGE_ID = mi.MENU_PAGE_ID,
                                PAGE_ID = mi.PAGE_ID,
                                SORT_ORDER = mi.SORT_ORDER,
                                STD_REGISTRY_ID = mi.STD_REGISTRY_ID,
                                STD_ROLE_ID = mi.STD_ROLE_ID,
                                UPDATED = mi.UPDATED,
                                UPDATEDBY = mi.UPDATEDBY
                            };

                            if (menuItem.STD_REGISTRY_ID > 0)
                            {
                                menuItem.STD_REGISTRY = dbContext.usp_STD_REGISTRY_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, menuItem.STD_REGISTRY_ID).FirstOrDefault();
                            }

                            if (menuItem.PAGE_ID > 0)
                            {
                                menuItem.STD_WEB_PAGES = dbContext.usp_STD_WEB_PAGES_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, menuItem.PAGE_ID).FirstOrDefault();
                            }

                            if (menuItem.MENU_PAGE_ID > 0)
                            {
                                menuItem.MENU_PAGE = dbContext.usp_STD_WEB_PAGES_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, menuItem.MENU_PAGE_ID).FirstOrDefault();
                            }

                            if (menuItem.STD_ROLE_ID > 0)
                            {
                                menuItem.STD_ROLE = dbContext.usp_STD_ROLE_getitem(CURRENT_USER, CURRENT_REGISTRY_ID, menuItem.STD_ROLE_ID).FirstOrDefault();
                            }

                            objReturn.Add(menuItem);
                        }
                    }
                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public List<STD_MENU_ITEMS> GetItemsByUserRegistryPath(string CURRENT_USER, Int32 CURRENT_REGISTRY_ID, string PATH)
        {
            List<STD_MENU_ITEMS> objReturn = null;
            List<MenuPages> objTemp = null;

            //TODO: Cleanup and make more efficient

            try
            {
                using (VIRPDBDataContext dbContext = GetDataContext())
                {
                    LogDetails logDetails = new LogDetails(String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                    objTemp = dbContext.usp_STD_MENU_ITEMS_getitemsByUserRegistryPath(CURRENT_USER, CURRENT_REGISTRY_ID, PATH).ToList();
                    if (objTemp != null)
                    {
                        objReturn = new List<STD_MENU_ITEMS>();
                        foreach (MenuPages mp in objTemp)
                        {
                            STD_MENU_ITEMS menuItem = new STD_MENU_ITEMS
                            {
                                SORT_ORDER = mp.STD_MENU_ITEMS_SORT_ORDER,
                                STD_REGISTRY = new STD_REGISTRY
                                {
                                    NAME = mp.STD_REGISTRY_NAME
                                },
                                MENU_PAGE = new STD_WEB_PAGES
                                {
                                    DISPLAY_TEXT = mp.MENU_PAGE_DISPLAY_TEXT,
                                    URL = mp.MENU_PAGE_URL
                                }
                            };

                            objReturn.Add(menuItem);
                        }
                    }

                    LogManager.LogTiming(logDetails);
                }
            }
            catch (Exception ex)
            {
                LogManager.LogError(ex.Message, String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CURRENT_USER, CURRENT_REGISTRY_ID);
                throw ex;
            }

            return objReturn;
        }

        public STD_MENU_ITEMS ParseReaderMenu(DataRow row)
        {
            STD_MENU_ITEMS objReturn = new STD_MENU_ITEMS()
            {
                SORT_ORDER = row.Field<int>("STD_MENU_ITEMS_SORT_ORDER"),
                STD_REGISTRY = new STD_REGISTRY() 
                {
                    NAME = row.Field<string>("STD_REGISTRY_NAME"),
                },
                MENU_PAGE = new STD_WEB_PAGES()
                {
                    DISPLAY_TEXT = row.Field<string>("MENU_PAGE_DISPLAY_TEXT"),
                    URL = row.Field<string>("MENU_PAGE_URL")
                }
            };

            return objReturn;
        }

		#endregion
	}
}
